%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% post processor - plot Cr
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc
clear all 
close all

%%%%%%%%%%% read finp.txt %%%%%%%%%%%%
fid = fopen('finp.txt','r');

line = fgets(fid);	% read line (Ne, Nn, Nb, Nm, Np)
v = sscanf(line, '%i');
Ne = v(1);
Nn = v(2);
Nb = v(3);
Nm = v(4);
Np = v(5);

line = fgets(fid);	% read line (Nd, Ng, Ns)
v = sscanf(line, '%i');
Ns = v(3);

line = fgets(fid);	% read line (Sx, Kappa, tc)
line = fgets(fid);	% read line (tmax, dt, dto)
line = fgets(fid);	% read line (theta)
line = fgets(fid);	% read line (ipar(2:3), ipar(6))
line = fgets(fid);	% read line (fpar(1:2), fpar(11))

%%%%%%%%%%% read fcount.txt %%%%%%%%%%%%
fid = fopen('fcount.txt','r');
line = fgets(fid);	% read line (Nc, Nf)
v = sscanf(line, '%i');
Nc = v(1);

%%%%%%%%%% read nodes.txt %%%%%%%%%%%
fid = fopen('nodes.txt','r');

x = zeros(Nn,1);
for n=1:Nn
  line = fgets(fid);	% read line (x, c(x,0 1:Ns))
  v = sscanf(line, '%e %e %s');
  x(n) = v(1);	%  (x)
end;	% n

%%%%%%%%%%% read fc.txt %%%%%%%%%%%%
Cr = zeros(Nn, Ns, Nc);
fid = fopen('fc.txt','r');
for k = 1:Nc;
  d = fscanf(fid, '%s %s',2);	% dummy
  d = fscanf(fid, '%i',1);	% dummy (n)
  d = fscanf(fid, '%s %s',2);	% dummy
  t(k) = fscanf(fid, '%e',1);	% time
  d = fscanf(fid, '%s',1);	% dummy (header)
  for n = 1:Nn;
      Cr(n,:,k) = fscanf(fid, '%e' ,Ns);	% Cr
  end	% n
  for s = 1:Ns;
    Cro(s,k) = Cr(Nn,s,k);		% store Cr at x=1
  end	% s
  for n = 1:Nn;
%%%%%%%%%%%%%%%%% currently only 3 sepcies are plotted and printed %%%%%%%%%%%%%%%%%
    Cr1 (n,k) = Cr(n, 1,k);		% store Cr of s=1
    Cr2 (n,k) = Cr(n, 2,k);		% store Cr of s=2
    CrNs(n,k) = Cr(n,Ns,k);		% store Cr of s=Ns
  end	% n
end	% k

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1)
hold;
for k = 1:Nc;
%%%%%%%%%%%%%%%%% currently only 3 sepcies are plotted and printed %%%%%%%%%%%%%%%%%
  plot(x,Cr1(:,k),'--', x,Cr2(:,k),'-.', x,CrNs(:,k))
end	% k
hold;
xlabel('x');
ylabel('C_r');
grid on;

figure(2)
hold;
% for s = 1:Ns;
%   plot(t,Cro(s,:))
% end	% s
plot(t,Cro(1,:),'--', t,Cro(2,:),'-.', t,Cro(Ns,:))
legend('A','B','C','Location','NorthEastOutside')
xlabel('t');
ylabel('C_r(x=L,t)');
grid on;
hold;

%%%%%%%%%%% write BTC_c.txt %%%%%%%%%%%%

fid = fopen('BTC_c.txt','w');
fprintf(fid, '% 5s % 14s % 14s \n', 'k', 't(k)', 'Cro(k)');
for k = 1:Nc;
%%%%%%%%%%%%%%%%% currently only 2 sepcies are plotted and printed %%%%%%%%%%%%%%%%%
  fprintf(fid, '% 5i % 14.7e% 14.7e % 14.7e % 14.7e \n', k, t(k), Cro(1,k), Cro(2,k), Cro(Ns,k) );
end	% k

fclose('all');  % close all files

